function[A B C A_nzlb B_nzlb B_zlb Indicator_Variables NY NX NK ]= Matrix_build_op_EW(var)
%% Dimensions:

%% Legend:
% c_s = c^s_t
% c_b = c^b_t
% y__= y
% pi_ = \pi_t
%i_s=i_t^s
%i_b = i_t^b
%b_b= b
%l_1=\lambda_1
%l_2=\lambda_2
%l_3=\lambda_3
%l_4=\lambda_4
%l_5=\lambda_5
%l_6=\lambda_6
%l_7=\lambda_7
%c_r= c_t^R
%i_s=i^ss_t
% d_t=d_t



%% Indicator
% CONTROLS ARE in t and t+1
% ENDOGENOUS STATES are in t-1 and t
% EXOGENOUS STATES are in t and t+1
Indicator_Controls=['y__','pi_' 'i_s' 'l_3'];
Indicator_En_States=['r_r' 'l_1' 'l_2' ];
Indicator_Ex_States=['iss','r_n'];

Indicator_Variables=[Indicator_Controls,Indicator_En_States,Indicator_Ex_States];

%% Dimensions
NY=length(Indicator_Variables)/3;
NX=length(Indicator_Ex_States)/3;
NK=NX+length(Indicator_En_States)/3;

%% Give the numbers

for i=0:length(Indicator_Variables)/3-1
eval(['ind_' Indicator_Variables(3*i+1:3*(i+1)) '=' num2str(i+1) ]);
eval(['ind_' num2str(i+1) '=' num2str(i+1) ]);

end

%% Initialize the Matrices
A=zeros(NY,NY);
B=zeros(NY,NY);
C= zeros(NY,NX);
%%
% AD
A(ind_1,ind_y__)=1;
A(ind_1,ind_pi_)=var.sigma;

B(ind_1,ind_y__)= 1;
B(ind_1,ind_i_s)= var.sigma;
B(ind_1,ind_r_n)= - var.sigma;


%%
% AS
A(ind_2,ind_pi_)= var.beta;

B(ind_2,ind_y__)= -var.k;
B(ind_2,ind_pi_)= 1;

%% Nothing
A(ind_3,ind_pi_)=1;

A(ind_3,ind_r_r)= - 1;

B(ind_3,ind_i_s)=1;



 


%% 


%% l_{2,t} k +l_{1,t}= y_t + l_{1,t-1}/beta
 
A(ind_4, ind_l_1)=1;
A(ind_4, ind_l_2)=var.k;

B(ind_4, ind_l_1)=1/var.beta;
B(ind_4, ind_y__)=1;

%% l_{2,t} = - lambda_pi pi_t -sigma/beta *l_1{t-1} + l_2{t-1}
A(ind_5, ind_l_2)= 1;

B(ind_5, ind_l_1)= - var.sigma/var.beta;
B(ind_5, ind_l_2)= 1;
B(ind_5, ind_pi_)= - var.lambda_pi;

%% ZLB

A(ind_6,ind_l_1)=var.sigma;

B(ind_6,ind_l_3)=-1;

%%
B(ind_7,ind_l_3)=1;
%% Exogenous Shock
A(ind_8,ind_iss)=1;

A(ind_9,ind_r_n)=1;

A_nzlb=A;
B_nzlb=B;

B_zlb=B_nzlb;
B_zlb(ind_7,:)=0;
%%

% Equation zlb:

% 0= i_t^s-i_t^{ss}
B_zlb(ind_7,ind_i_s)= 1;
B_zlb(ind_7,ind_iss)= -1;



